function init_event()
    local checker_texture = ag.loadTexture("checker.jpg")

    checker_box = ag.createBox(8, 8, 0.1, {static = true})
    checker_box:setPosition(0, 0, 0.1/2)
    checker_box:setTexture(checker_texture)
    checker_box:setTextureScale(2)

    hilite = ag.createBox(1, 1, 0.1, {static = true, enable_blending = true})
    hilite:setColor(0.3, 0.5, 1)
    hilite:setPosition(1.5, 1.5, 0.15)
    hilite:setTransparency(0.4)

    ag.setCamera(4, -8, 8, 0, 0, 0)
    ag.setCursorVisible(true)
end

function mouse_motion_event(x, y, xrel, yrel)
    local hit = ag.pickOne(x, y, checker_box)
    if hit then
        local cx, cy = checker_box:getPosition()
        local sx, sy = checker_box:getSize()
        local px = checker_box.pick_pos[1]
        local py = checker_box.pick_pos[2]
        local x_coord = math.floor((px - cx + sx / 2) * 8 / sx)
        local y_coord = math.floor((py - cy + sy / 2) * 8 / sy)
        if x_coord >= 0 and x_coord <= 7 and y_coord >= 0 and y_coord <= 7 then
            hilite:setPosition((x_coord - 3.5) * sx / 8 + cx,
                (y_coord - 3.5) * sy / 8 + cy, 0.15)
        end
    end
end

function mousebutton_down_event(button, x, y)
    if (button == 1) then
        local spawnSphere = ag.createSphere(0.45)
        spawnSphere:setColor(math.random(), math.random(), math.random())
        local hlx, hly = hilite:getPosition()
        spawnSphere:setPosition(hlx, hly, 0.6)
        spawnSphere:addForce(0, 0, 100)
    end
end
